% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_all_transcripts}
\alias{plot_all_transcripts}
\title{Plot All Transcripts}
\usage{
plot_all_transcripts(
  object,
  features,
  embedding = "UMAP",
  from_gene = TRUE,
  ...
)
}
\arguments{
\item{object}{A object}

\item{features}{gene or vector of transcripts}

\item{embedding}{umap}

\item{from_gene}{whether to look up transcripts for an input gene}

\item{...}{additional arguments passed to plot_feature_on_embedding}
}
\value{
a list of embedding plots colored by a feature of interest
}
\description{
plot expression all transcripts for an input gene superimposed on embedding
}
\examples{
data("tiny_sce")
plot_all_transcripts(tiny_sce, "NRL", from_gene = TRUE)

}
