% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distance_matrix.R
\name{plot_distance_matrix}
\alias{plot_distance_matrix}
\title{Plot Distance Matrix from CNVCalling}
\usage{
plot_distance_matrix(cnvcall)
}
\arguments{
\item{cnvcall}{cnvcalling result from function call_cnv.R}
}
\value{
ggplot object ; distance matrix per cnvcalling solution
}
\description{
Plot Distance Matrix from CNVCalling
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
### Example PoN
PoN_rdsfile <- system.file("extdata","ex.PoN.rds",package = "cfdnakit")
pon_profiles <- readRDS(PoN_rdsfile)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")

sample_zscore <- get_zscore_profile(sample_profile,pon_profiles)
sample_zscore_segment <- segmentByPSCB(sample_zscore)

sample_cnv <- call_cnv(sample_zscore_segment,sample_zscore, tfs=c(0.1,0.3),ploidies=c(1.5,2), MaxCN=3)
plot_distance_matrix(sample_cnv)


}
