% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_cnv.R
\name{call_cnv}
\alias{call_cnv}
\title{Call Copy-number Variation from SLRatio and segmentation}
\usage{
call_cnv(
  sample_segmentation,
  sample_zscore,
  callChr = seq_len(22),
  tfs = c(0, 0.7),
  ploidies = c(1.5, 3),
  MaxCN = 4
)
}
\arguments{
\item{sample_segmentation}{segmentation dataframe from segmentByPSCBS}

\item{sample_zscore}{zscore dataframe}

\item{callChr}{chromosome to analysis : Default c(1:22)}

\item{tfs}{range of fitting tumor fraction : Default c(0,0.8)}

\item{ploidies}{range of fitting chromosomal ploidy : Default c(1.5,4)}

\item{MaxCN}{maximum copy-number : Default 4}
}
\value{
List of cnvcalling solutions
}
\description{
Call Copy-number Variation from SLRatio and segmentation
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
### Example PoN
PoN_rdsfile <- system.file("extdata","ex.PoN.rds",package = "cfdnakit")
pon_profiles <- readRDS(PoN_rdsfile)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")

sample_zscore <- get_zscore_profile(sample_profile,pon_profiles)

sample_zscore_segment <- segmentByPSCB(sample_zscore)

sample_cnv <- call_cnv(sample_zscore_segment,sample_zscore, tfs=c(0.1,0.3),ploidies=c(1.5,2), MaxCN=3)
plot_cnv_solution(sample_cnv,selected_solution = 1)

}
