% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfDeconvolve.R
\name{cfDeconvolve}
\alias{cfDeconvolve}
\title{cfDNA methylation read deconvolution}
\usage{
cfDeconvolve(
  readsBinningFile,
  tissueMarkersFile,
  numTissues,
  emAlgorithmType = "em.global.unknown",
  likelihoodRatioThreshold = 2,
  emMaxIterations = 100,
  randomSeed = 0,
  id = "sample"
)
}
\arguments{
\item{readsBinningFile}{a file of the fragment-level methylation states 
of reads that mapped to the markers. Either in plain text or compressed form.}

\item{tissueMarkersFile}{a file of paired shape parameters of beta 
distributions for markers.}

\item{numTissues}{a number of tissue types.}

\item{emAlgorithmType}{a read-based tissue deconvolution EM algorithm type: 
em.global.unknown (default), em.global.known, em.local.unknown, 
em.local.known.}

\item{likelihoodRatioThreshold}{a positive float number. Default is 2.}

\item{emMaxIterations}{a number of EM algorithm maximum iteration. 
Default is 100.}

\item{randomSeed}{a random seed that initialize the EM algorithm. 
Default is 0.}

\item{id}{the sample ID.}
}
\value{
a list containing the cfDNA fractions of different 
tissue types and an unknown class.
}
\description{
Infer the tissue-type composition of plasma cfDNA.
}
\examples{
## input files
demo.dir <- system.file("data", package="cfTools")
readsBinningFile <- file.path(demo.dir, "cfDeconvolve.reads.txt.gz")
tissueMarkersFile <- file.path(demo.dir, "cfDeconvolve.markers.txt.gz")
numTissues <- 7
emAlgorithmType <- "em.global.unknown"
likelihoodRatioThreshold <- 2
emMaxIterations <- 100
randomSeed <- 0
id <- "test"

cfDeconvolve(readsBinningFile, tissueMarkersFile, numTissues, 
emAlgorithmType, likelihoodRatioThreshold, emMaxIterations, randomSeed, id)

}
