% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSingleGroup.R
\name{plotSingleGroup}
\alias{plotSingleGroup}
\title{Plot the raw fragment size metrics of single group in a single plot,
colored by samples.}
\usage{
plotSingleGroup(x, xlim, ylim, vline, order, plot, ...)
}
\arguments{
\item{x}{A long-format dataframe contains the metrics of different cohort.}

\item{xlim}{The x axis range shown in the plot. Default is `c(0,500)`.}

\item{ylim}{The y axis range shown in the fraction of fragment size plots.
Default is `c(0,0.035)`.}

\item{vline}{Vertical dashed lines, default value is `c(81,167)`.}

\item{order}{The groups show in the final plot,
the input value should be vector,
e.g. `order = c('group1')``,
default is all groups/cohorts in the folder path.}

\item{plot}{The plot type, default is 'all' which means both proportion,
cdf and 1-cdf plots will be shown.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns a list plots.
}
\description{
Plot the raw fragment size metrics of single group in a single plot,
colored by samples.
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")

# Calculate the metrics.
df <- callMetrics(path = path)

# Plot the only the group specified..
plot <- plotSingleGroup(x = df, order = c("cohort_1"))
}
\author{
Haichao Wang
}
