% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callValleyDistance.R
\name{callValleyDistance}
\alias{callValleyDistance}
\title{Calculate the inter-valley distance of insert size}
\usage{
callValleyDistance(
  path = getwd(),
  groups,
  limit,
  outfmt,
  summary,
  mincount,
  input_type,
  ...
)
}
\arguments{
\item{path}{The root folder containing all groups folders,
default is the present working folder.}

\item{groups}{The name of the groups, the input value should be vector,
e.g. groups = c('group1','group2'), default is all folders
in the folder path.}

\item{limit}{The insert size range that will be focused on,
default value is `limit = c(35,135)`.}

\item{outfmt}{The output format,
could specify as 'list' or 'dataframe' or 'df',
default is dataframe.}

\item{summary}{If TRUE, summarize the output.}

\item{mincount}{The minimum count value of inter-valley distance.}

\item{input_type}{Character. The input file format
should be 'picard' or 'bam', or 'cfdnapro'. The bam files has to be 
marked duplicates.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The inter-valley distance in a list or dataframe.
}
\description{
Calculate the inter-valley distance of insert size
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")
# Calculate the inter-valley distance.
df <- callValleyDistance(path = path)
}
\author{
Haichao Wang
}
