% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callSize.R
\name{callSize}
\alias{callSize}
\title{Calculate the insert size metrics (i.e. prop, cdf, 1-cdf) or each group}
\usage{
callSize(path, groups, outfmt, input_type, ...)
}
\arguments{
\item{path}{The root folder containing all groups folders,
default is the present working folder.}

\item{groups}{The name of the groups, the input value should be vector,
e.g. `groups=c('group1','group2')`,
default is all folders in the folder path.}

\item{outfmt}{The output format,
could specify as 'list' or 'dataframe' or 'df',
default is dataframe.}

\item{input_type}{Character. The input file format,
should be one of these: 'picard', 'bam', 'cfdnapro'. 
The bam files has to be marked duplicates.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns the insert size metrics
  of each group in list or dataframe format.
}
\description{
Calculate the insert size metrics (i.e. prop, cdf, 1-cdf) or each group
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")
# Calculate the size.
df <- callSize(path = path)
}
\author{
Haichao Wang
}
