% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callMode.R
\name{callMode}
\alias{callMode}
\title{Calculate the mode fragment size of each sample}
\usage{
callMode(
  path,
  groups,
  outfmt = "df",
  order = groups,
  summary,
  mincount,
  input_type,
  ...
)
}
\arguments{
\item{path}{The root folder containing all groups folders,
default is the present working folder.}

\item{groups}{The name of the groups, the input value should be vector,
e.g. groups=c('group1','group2'),
default is all folders in the folder path.}

\item{outfmt}{The output format, 'list' or 'dataframe' or 'df',
default is dataframe.}

\item{order}{The order in the sorted output,
default value equals to 'groups' parameter.}

\item{summary}{Summarize the dataframe result
by calculating each mode size and its count number.
Default value is False.}

\item{mincount}{Minimum count number of each mode size
in the summarized output.
Only significant when 'summary = TRUE'.}

\item{input_type}{Character. The input file format,
should be one of these: 'picard', 'bam', 'cfdnapro'. 
The bam files has to be marked duplicates.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns the inter valley distance
    in list or dataframe format.
}
\description{
Calculate the mode fragment size of each sample
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")
# Calculate the mode.
df <- callMode(path = path)
}
\author{
Haichao Wang
}
