\name{get_treatment_profile}
\alias{get_treatment_profile}
\title{Visualization of treatment effect profiles}
\usage{
get_treatment_profile(x,
                      hc_link = "average",
                      hc_dist = "euclidean",
                      groups,
                      B = 1000)
}
\arguments{
  \item{x}{An object generated by \code{cellmig}}
  \item{hc_link}{hierarchical clustering linkage function}
  \item{hc_dist}{hierarchical clustering distance metric}
  \item{groups}{use only selected treatment groups}
  \item{B}{number of samples to draw from posterior}
}
\value{
Hierarchical dendrogram comparing treatment group effects.
}
\description{
The function takes as its main input (\code{x}) the output of the 
\code{cellmig} function. Users can select a subset of treatment groups
(compounds + dose combinations) using \code{groups}. To construct the
hierarchical dendrogram, one has to select a distance metric, 
\code{hc_dist}, (e.g. \code{hc_dist} = "euclidean"); and a linkage 
function, \code{hc_link}, (e.g. \code{hc_link} = "average").
}
\details{
The function \code{get_treatment_profile} visualizes treatment group effect 
profiles: these treatment groups are clustered together in a hierarchical 
dendrogram.
}
\examples{
data(d, package = "cellmig")
o <- cellmig(x = d,
            control = list(mcmc_warmup = 200,
                           mcmc_steps = 500,
                           mcmc_chains = 2,
                           mcmc_cores = 2,
                           mcmc_algorithm = "NUTS",
                           adapt_delta = 0.8,
                           max_treedepth = 10))
                           
p <- get_treatment_profile(x = o,
                           hc_link = "average",
                           hc_dist = "euclidean",
                           B = 100)
p
}
