\name{get_groups}
\alias{get_groups}
\title{Extract group labels}
\description{
  This function extracts treatment group metadata from an object generated by
  \code{cellmig}.
}
\usage{
  get_groups(x)
}
\arguments{
  \item{x}{An object generated by \code{cellmig}, containing treatment group
  names and IDs, compound names and dose.}
}
\details{
  The function retrieves group metadata such as group identifiers, names, 
  compound information, and dose levels.
}
\value{
  A data frame containing the following columns:
  \item{group_id}{Unique identifier for each treatment group.}
  \item{group}{Name of the treatment group.}
  \item{compound}{Compound associated with the treatment group.}
  \item{dose}{Dose level of the compound.}
}
\examples{
data(d_mini, package = "cellmig")
o <- cellmig(x = d_mini,
             control = list(mcmc_warmup = 200,
                            mcmc_steps = 500,
                            mcmc_chains = 2,
                            mcmc_cores = 2,
                            mcmc_algorithm = "NUTS",
                            adapt_delta = 0.8,
                            max_treedepth = 10))
u <- get_groups(x = o)
}
\seealso{
  \code{cellmig}, \code{get_pairs}, \code{get_groups}, \code{get_violins}
}
