% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{getVACtable}
\alias{getVACtable}
\title{Getting the Velocity AutoCorrelation}
\usage{
getVACtable(object)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of
data frames resulted from the PreProcessing.}
}
\value{
A data frame, which contains six rows: "Cell Number",
"Velocity AutoCorrelation (lag=1)",
"2nd normalized Velocity AutoCorrelation",
"Intercept of VA quadratic model",
"Mean Velocity AutoCorrelation (all lags)", "Mean |Acceleration|"
and "Average Speed".
}
\description{
The VeAutoCor function automatically compute the
changes in both speed and direction across several sequantial
time intervals.
}
\examples{
data(TrajectoryDataset)
rmDF=TrajectoryDataset[seq(1,300,by=1),]
rmTD <- CellMig(rmDF)
rmTD <- rmPreProcessing(rmTD,FrameN=55)
rmTD <- VeAutoCor(rmTD, TimeInterval=10, sLAG=0.25, sPLOT=FALSE,
                  aPLOT=FALSE, export=FALSE)
head(getVACtable(rmTD))

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
