% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{VisualizeStackCentroids}
\alias{VisualizeStackCentroids}
\title{Visualize Cells in an Image Stack}
\usage{
VisualizeStackCentroids(
  tc_obj,
  stack = 1,
  pnt.cex = 1.2,
  txt.cex = 0.9,
  offset = 0.18,
  main = NULL
)
}
\arguments{
\item{tc_obj}{a \code{trackedCells} object}

\item{stack}{index of the image stack to use}

\item{pnt.cex}{cex of the points drawn around cells}

\item{txt.cex}{cex of the text used to annotate cells}

\item{offset}{offset value for the annotation}

\item{main}{string used for the plot title, can be NULL= NULL}
}
\value{
None
}
\description{
Visualize objects that were identified as cells in a given image
stack
}
\examples{
# Representative output
x <- get(data(TrackCellsDataset))
VisualizeStackCentroids(tc_obj = x, stack = 2, pnt.cex = 5, offset = 1.3)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
