% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{LoadTiff}
\alias{LoadTiff}
\title{Import Image from TIFF}
\usage{
LoadTiff(tiff_file, experiment = NULL, condition = NULL, replicate = NULL)
}
\arguments{
\item{tiff_file}{path to a TIFF file to be read in}

\item{experiment}{string, a label to describe the experiment
(optional)}

\item{condition}{string, a label to describe the experimental
condition}

\item{replicate}{string, a label to identify the replicate
(optional)}
}
\value{
a trackedCells object
}
\description{
Import a .tif stack containing fluorescently labeled point particles
to be tracked
}
\note{
`experiment`, `condition` and `replicate` are optional
arguments
and can be NULL.
}
\examples{
# Let `path/to/tiff_file.tiff` be the path to tiff file we want to
# import. If an error is thrown, NULL is returned.
x <- LoadTiff(tiff_file = "path/to/tiff_file.tiff")

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
