% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{ForwardMigration}
\alias{ForwardMigration}
\title{Forward Migration}
\usage{
ForwardMigration(
  object,
  TimeInterval = 10,
  sfptPLOT = TRUE,
  afptPLOT = TRUE,
  sfpPLOT = TRUE,
  afpPLOT = TRUE,
  export = FALSE,
  ExpName = NULL
)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of data
frames resulted from the PreProcessing.}

\item{TimeInterval}{A numeric value of the time elapsed between
successive frames in the time-lapse stack.}

\item{sfptPLOT}{A logical vector that allows generating individual
plots of persistence time vs speed per cell. Default is TRUE.}

\item{afptPLOT}{A logical vector that allows generating a plot of
persistence time vs speed for all cells. Default is TRUE.}

\item{sfpPLOT}{A logical vector that allows generating individual
plots of angular persistence vs speed per cell. Default is TRUE.}

\item{afpPLOT}{A logical vector that allows generating a plot of
angular persistence vs speed of all cells. Default is TRUE.}

\item{export}{if `TRUE` (default), exports function output to CSV
file}

\item{ExpName}{string, name of the experiment. Can be NULL}
}
\value{
An CellMig class Object with a data frame and plots.
The data frame is stored in the ForMigtable slot.
}
\description{
The ForwardMigration function automatically generates
data and plots for forward persistence and speed.
}
\examples{
data(WSADataset)
wsaDF <- WSADataset[seq(1,500,by=1),]
wsaTD <- CellMig(wsaDF)
wsaTD <- wsaPreProcessing(wsaTD,FrameN=55)
wsaTD <-ForwardMigration(wsaTD, TimeInterval=10, sfptPLOT=FALSE,
                         afptPLOT= FALSE,sfpPLOT= FALSE,
                         afpPLOT= FALSE, export=FALSE)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
