% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CellBaseParam-class}
\alias{CellBaseParam-class}
\title{CellBaseParam Class}
\description{
This class  defines a CellBaseParam object to hold filtering 
parameters.
}
\details{
This class stores parameters used for filtering the CellBaseR query
and is avaialable for all query methods. CellBaseParam object is used to
control what results are returned from the' CellBaseR methods
}
\section{Slots}{

\describe{
\item{\code{assembly}}{A character the assembly build to query, e.g.GRCh37(default)}

\item{\code{feature}}{A character vector denoting the feature/s to be queried}

\item{\code{region}}{A character vector denoting the region/s to be queried must be 
in the form 1:100000-1500000}

\item{\code{rsid}}{A character vector denoting the rs ids to be queried}

\item{\code{accession}}{A caharcter vector of Cinvar accessions}

\item{\code{type}}{A caharcter vector of Variant types}

\item{\code{mode_inheritance_labels}}{A character vector}

\item{\code{clinsig_labels}}{A character vector}

\item{\code{alleleOrigin}}{A character vector}

\item{\code{consistency_labels}}{A character vector}

\item{\code{so}}{A character vector denoting sequence ontology to be queried}

\item{\code{source}}{A character vector}

\item{\code{trait}}{A character vector denoting the trait to be queried}

\item{\code{include}}{A character vector denoting the fields to be returned}

\item{\code{exclude}}{A character vector denoting the fields to be excluded}

\item{\code{limit}}{A number limiting the number of results to be returned}
}}

\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
