% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTranscript-methods.R
\docType{methods}
\name{getTranscript,CellBaseR-method}
\alias{getTranscript,CellBaseR-method}
\alias{getTranscript}
\title{getTranscript}
\usage{
\S4method{getTranscript}{CellBaseR}(object, ids, resource, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{ids}{a character vector of the transcript ids to be queried, use 
ensemble transccript IDs eq, ENST00000380152}

\item{resource}{a character vector to specify the resource to be queried}

\item{param}{an object of class CellBaseParam specifying additional params 
for the query}
}
\value{
a dataframe with the results of the query
}
\description{
A method to query transcript data from Cellbase web services.
}
\details{
This method retrieves various genomic annotations for transcripts
 including exons, cDNA sequence, annotations flags, and cross references,etc.
}
\examples{
   cb <- CellBaseR()
   res <- getTranscript(object=cb, ids="ENST00000373644", resource="info")
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
