% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTf-methods.R
\docType{methods}
\name{getTf,CellBaseR-method}
\alias{getTf,CellBaseR-method}
\alias{getTf}
\title{getTf}
\usage{
\S4method{getTf}{CellBaseR}(object, ids, resource, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{ids}{a character vector of the ids to be queried, must be a valid 
transcription factor name, for example, 
eg, CTCF}

\item{resource}{a character vector to specify the resource to be queried}

\item{param}{a object of class CellBaseParam specifying additional param
for the query}
}
\value{
a dataframe with the results of the query
}
\description{
A method to query transcription factors binding sites data from Cellbase web
 services.
}
\details{
This method retrieves various transcription factors binding sites 
data
}
\examples{
   cb <- CellBaseR()
   param <- CellBaseParam(limit = 12)
   res <- getTf(object=cb, ids="CTCF", resource="tfbs", param=param)
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
