% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSnp-methods.R
\docType{methods}
\name{getSnp,CellBaseR-method}
\alias{getSnp,CellBaseR-method}
\alias{getSnp}
\title{getSnp}
\usage{
\S4method{getSnp}{CellBaseR}(object, ids, resource, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{ids}{a character vector of the ids to be queried, must be a valid rsid,
for example 'rs6025'}

\item{resource}{a character vector to specify the resource to be queried}

\item{param}{a object of class CellBaseParam specifying additional param
for the query}
}
\value{
a dataframe with the results of the query
}
\description{
A method to query genomic variation data from Cellbase web services.
}
\details{
.

This method retrieves known genomic variants (snps) and their
annotations including population frequncies from 1k genomes and Exac projects
as well as clinical data and various other annotations
}
\examples{
cb <- CellBaseR()
res <- getSnp(object=cb, ids="rs6025", resource="info")
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
