% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProtein-methods.R
\docType{methods}
\name{getProtein,CellBaseR-method}
\alias{getProtein,CellBaseR-method}
\alias{getProtein}
\title{getProtein}
\usage{
\S4method{getProtein}{CellBaseR}(object, ids, resource, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{ids}{a character vector of uniprot ids to be queried, should be one
or more of uniprot ids, for example O15350.}

\item{resource}{a character vector to specify the resource to be queried}

\item{param}{a object of class CellBaseParam specifying additional param
for the query}
}
\value{
an object of class CellBaseResponse which holds a dataframe with th
e results of the query
}
\description{
A method to query protein data from Cellbase web services.
}
\details{
This method retrieves various protein annotations including 
protein description, features, sequence, substitution scores, evidence,  etc.
}
\examples{
   cb <- CellBaseR()
   res <- getProtein(object=cb, ids="O15350", resource="info")
}
