% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getChromosomeInfo-methods.R
\docType{methods}
\name{getChromosomeInfo,CellBaseR-method}
\alias{getChromosomeInfo,CellBaseR-method}
\alias{getChromosomeInfo}
\title{getChromosomeInfo}
\usage{
\S4method{getChromosomeInfo}{CellBaseR}(object, ids, resource, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{ids}{a character vector of chromosome ids to be queried}

\item{resource}{a character vector to specify the resource to be queried}

\item{param}{a object of class CellBaseParam specifying additional param for
the query}
}
\value{
a dataframe with the results of the query
}
\description{
A method to query sequence data from Cellbase web services.
}
\details{
A method to query sequence data from Cellbase web services. This 
method retrieves information about chromosomes, including its size and
detailed information about its different cytobands
}
\examples{
   cb <- CellBaseR()
   res <- getChromosomeInfo(object=cb, ids="22", resource="info")
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
