% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCellbase-methods.R
\docType{methods}
\name{getCellBase,CellBaseR-method}
\alias{getCellBase,CellBaseR-method}
\alias{getCellBase}
\title{getCellBase}
\usage{
\S4method{getCellBase}{CellBaseR}(object, category, subcategory, ids, resource,
  param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{category}{character to specify the category to be queried.}

\item{subcategory}{character to specify the subcategory to be queried}

\item{ids}{a character vector of the ids to be queried}

\item{resource}{a character to specify the resource to be queried}

\item{param}{an object of class CellBaseParam specifying additional param
for the CellBaseR}
}
\value{
a dataframe holding the results of the query
}
\description{
The generic method for querying CellBase web services.
}
\details{
This method allows the user to query the 
cellbase web services without any  predefined categories, subcategries, 
or resources.
}
\examples{
   cb <- CellBaseR()
   res <- getCellBase(object=cb, category="feature", subcategory="gene", 
   ids="TET1", resource="info")
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
