% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CellBaseR-class}
\alias{CellBaseR-class}
\title{CellBaseR Class}
\description{
This is an S4 class  which defines the CellBaseR object
}
\details{
This S4 class holds the default configuration required by CellBaseR 
methods to connect to the cellbase web 
services. By default it is configured to query human data based on the GRCh37
genome assembly.
}
\section{Slots}{

\describe{
\item{\code{host}}{a character specifying the host url. Default 
"http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/rest/"}

\item{\code{version}}{a character specifying the API version. Default "v4"}

\item{\code{species}}{a character specifying the species to be queried. Default
"hsapiens"}

\item{\code{batch_size}}{if multiple queries are raised by a single method call, e.g.
 getting annotation info for several genes,
queries will be sent to the server in batches. This slot indicates the size 
of these batches. Default 200}

\item{\code{num_threads}}{the number of threads. Default 8}
}}

\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
