% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellBaseParam-methods.R
\name{CellBaseParam}
\alias{CellBaseParam}
\title{A Constructor for the CellBaseParam Object}
\usage{
CellBaseParam(genome = character(), gene = character(),
  region = character(), rs = character(), so = character(),
  phenotype = character(), include = character(), exclude = character(),
  limit = character())
}
\arguments{
\item{genome}{A character denoting the genome build to query,eg, GRCh37
(default),or GRCh38}

\item{gene}{A character vector denoting the gene/s to be queried}

\item{region}{A character vector denoting the region/s to be queried must be
in the form 1:100000-1500000 not chr1:100000-1500000}

\item{rs}{A character vector denoting the rs ids to be queried}

\item{so}{A character vector denoting sequence ontology to be queried}

\item{phenotype}{A character vector denoting the phenotype to be queried}

\item{include}{A character vector denoting the fields to be returned}

\item{exclude}{A character vector denoting the fields to be excluded}

\item{limit}{A number limiting the number of results to be returned}
}
\value{
an object of class CellBaseParam
}
\description{
CellBaseParam object is used to control what results are returned from the
CellBaseR methods
}
\examples{
cbParam <- CellBaseParam(genome="GRCh38",gene=c("TP73","TET1"))
print(cbParam)
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
