% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topRank.R
\name{topRank}
\alias{topRank}
\title{Identify features with the highest influence on clustering.}
\usage{
topRank(matrix, n = 25, margin = 2, threshold = 0, decreasing = TRUE)
}
\arguments{
\item{matrix}{Numeric matrix.}

\item{n}{Integer. Maximum number of items above `threshold` returned for each
ranked row or column.}

\item{margin}{Integer. Dimension of `matrix` to rank, with 1 for rows, 2 for
columns. Default 2.}

\item{threshold}{Numeric. Only return ranked rows or columns in the matrix
that are above this threshold. If NULL, then no threshold will be applied.
Default 0.}

\item{decreasing}{Logical. Specifies if the rank should be decreasing.
Default TRUE.}
}
\value{
List. The `index` variable provides the top `n` row (feature) indices
 contributing the most to each column (cell). The `names` variable provides
 the rownames corresponding to these indexes.
}
\description{
topRank() can quickly identify the top `n` rows for each column
 of a matrix. For example, this can be useful for identifying the top `n`
 features per cell.
}
\examples{
data(sampleCells)
topRanksPerCell <- topRank(sampleCells, n = 5)
topFeatureNamesForCell <- topRanksPerCell$names[1]
}
