% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{runParams}
\alias{runParams}
\alias{runParams,SingleCellExperiment-method}
\alias{runParams,celdaList-method}
\title{Get run parameters from a celda model
 \code{SingleCellExperiment} or \code{celdaList} object}
\usage{
runParams(x, altExpName = "featureSubset")

\S4method{runParams}{SingleCellExperiment}(x, altExpName = "featureSubset")

\S4method{runParams}{celdaList}(x)
}
\arguments{
\item{x}{An object of class \linkS4class{SingleCellExperiment} or class
\code{celdaList}.}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
Data Frame. Contains details on the various K/L parameters, chain
 parameters, seed, and final log-likelihoods derived for each model in the
 provided celdaList.
}
\description{
Returns details on the clustering parameters and model
 priors from the celdaList object when it was created.
}
\examples{
data(sceCeldaCGGridSearch)
runParams(sceCeldaCGGridSearch)
data(celdaCGGridSearchRes)
runParams(celdaCGGridSearchRes)
}
