% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{logLikelihood}
\alias{logLikelihood}
\alias{logLikelihood,SingleCellExperiment,ANY-method}
\alias{logLikelihood,matrix,celda_C-method}
\alias{logLikelihood,matrix,celda_G-method}
\alias{logLikelihood,matrix,celda_CG-method}
\title{Calculate the Log-likelihood of a celda model}
\usage{
logLikelihood(x, celdaMod, useAssay = "counts", altExpName = "featureSubset")

\S4method{logLikelihood}{SingleCellExperiment,ANY}(x, useAssay = "counts", altExpName = "featureSubset")

\S4method{logLikelihood}{matrix,celda_C}(x, celdaMod)

\S4method{logLikelihood}{matrix,celda_G}(x, celdaMod)

\S4method{logLikelihood}{matrix,celda_CG}(x, celdaMod)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object returned by
\link{celda_C}, \link{celda_G}, or \link{celda_CG}, with the matrix
located in the \code{useAssay} assay slot.
Rows represent features and columns represent cells.}

\item{celdaMod}{celda model object. Ignored if \code{x} is a
\linkS4class{SingleCellExperiment} object.}

\item{useAssay}{A string specifying which \link{assay}
slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
The log-likelihood of the cluster assignment for the
 provided \linkS4class{SingleCellExperiment}.
}
\description{
Calculate the log-likelihood for cell population
 and feature module cluster assignments on the count matrix, per celda model.
}
\examples{
data(sceCeldaC, sceCeldaCG)
loglikC <- logLikelihood(sceCeldaC)
loglikCG <- logLikelihood(sceCeldaCG)
}
\seealso{
`celda_C()` for clustering cells
}
