% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_functions.R
\name{featureModuleTable}
\alias{featureModuleTable}
\title{Output a feature module table}
\usage{
featureModuleTable(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  displayName = NULL,
  outputFile = NULL
)
}
\arguments{
\item{sce}{A \linkS4class{SingleCellExperiment} object returned by
\link{celda_G}, or \link{celda_CG}, with the matrix
located in the \code{useAssay} assay slot.
Rows represent features and columns represent cells.}

\item{useAssay}{A string specifying which \link{assay}
slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{displayName}{Character. The column name of
\code{rowData(sce)} that specifies the display names for
the features. Default \code{NULL}, which displays the row names.}

\item{outputFile}{File name for feature module table. If NULL, file will
not be created. Default NULL.}
}
\value{
Matrix. Contains a list of features per each column (feature module)
}
\description{
Creates a table that contains the list of features in
 each feature module.
}
\examples{
data(sceCeldaCG)
featureModuleTable(sceCeldaCG)
}
