% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorizeMatrix.R
\name{factorizeMatrix}
\alias{factorizeMatrix}
\alias{factorizeMatrix,SingleCellExperiment,ANY-method}
\alias{factorizeMatrix,ANY,celda_CG-method}
\alias{factorizeMatrix,ANY,celda_C-method}
\alias{factorizeMatrix,ANY,celda_G-method}
\title{Generate factorized matrices showing each feature's influence on cell
 / gene clustering}
\usage{
factorizeMatrix(
  x,
  celdaMod,
  useAssay = "counts",
  altExpName = "featureSubset",
  type = c("counts", "proportion", "posterior")
)

\S4method{factorizeMatrix}{SingleCellExperiment,ANY}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  type = c("counts", "proportion", "posterior")
)

\S4method{factorizeMatrix}{ANY,celda_CG}(x, celdaMod, type = c("counts", "proportion", "posterior"))

\S4method{factorizeMatrix}{ANY,celda_C}(x, celdaMod, type = c("counts", "proportion", "posterior"))

\S4method{factorizeMatrix}{ANY,celda_G}(x, celdaMod, type = c("counts", "proportion", "posterior"))
}
\arguments{
\item{x}{Can be one of
\itemize{
\item A \linkS4class{SingleCellExperiment} object returned by
\link{celda_C}, \link{celda_G} or \link{celda_CG}, with the matrix
located in the \code{useAssay} assay slot in \code{altExp(x, altExpName)}.
Rows represent features and columns represent cells.
\item Integer counts matrix. Rows represent features and columns represent
cells. This matrix should be the same as the one used to generate
\code{celdaMod}.}}

\item{celdaMod}{Celda model object. Only works if \code{x} is an integer
counts matrix.}

\item{useAssay}{A string specifying which \link{assay}
slot to use if \code{x} is a \linkS4class{SingleCellExperiment} object.
Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{type}{Character vector. A vector containing one or more of "counts",
"proportion", or "posterior". "counts" returns the raw number of counts for
each factorized matrix. "proportions" returns the normalized probabilities
for each factorized matrix, which are calculated by dividing the raw counts
in each factorized matrix by the total counts in each column. "posterior"
returns the posterior estimates which include the addition of the Dirichlet
concentration parameter (essentially as a pseudocount). Default
\code{"counts"}.}
}
\value{
For celda_CG model, A list with elements for "counts", "proportions",
 or "posterior" probabilities. Each element will be a list containing
 factorized matrices for "module", "cellPopulation", and "sample".
 Additionally, the contribution of each module in each individual cell will
 be included in the "cell" element of "counts" and "proportions" elements.

For celda_C model, a list with elements for "counts", "proportions",
 or "posterior" probabilities. Each element will be a list containing
 factorized matrices for "module" and "sample".

For celda_G model, a list with elements for "counts", "proportions",
 or "posterior" probabilities. Each element will be a list containing
 factorized matrices for "module" and "cell".
}
\description{
Generates factorized matrices showing the contribution of each
 feature in each cell population or each cell population in each sample.
}
\examples{
data(sceCeldaCG)
factorizedMatrices <- factorizeMatrix(sceCeldaCG, type = "posterior")
data(celdaCGSim, celdaCGMod)
factorizedMatrices <- factorizeMatrix(
  celdaCGSim$counts,
  celdaCGMod,
  "posterior")
data(celdaCSim, celdaCMod)
factorizedMatrices <- factorizeMatrix(
  celdaCSim$counts,
  celdaCMod, "posterior"
)
data(celdaGSim, celdaGMod)
factorizedMatrices <- factorizeMatrix(
  celdaGSim$counts,
  celdaGMod, "posterior"
)
}
