% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celdatosce.R
\name{celdatosce}
\alias{celdatosce}
\alias{celdatosce,celda_C-method}
\alias{celdatosce,celda_G-method}
\alias{celdatosce,celda_CG-method}
\alias{celdatosce,celdaList-method}
\title{Convert old celda model object to \code{SCE} object}
\usage{
celdatosce(
  celdaModel,
  counts,
  useAssay = "counts",
  altExpName = "featureSubset"
)

\S4method{celdatosce}{celda_C}(
  celdaModel,
  counts,
  useAssay = "counts",
  altExpName = "featureSubset"
)

\S4method{celdatosce}{celda_G}(
  celdaModel,
  counts,
  useAssay = "counts",
  altExpName = "featureSubset"
)

\S4method{celdatosce}{celda_CG}(
  celdaModel,
  counts,
  useAssay = "counts",
  altExpName = "featureSubset"
)

\S4method{celdatosce}{celdaList}(
  celdaModel,
  counts,
  useAssay = "counts",
  altExpName = "featureSubset"
)
}
\arguments{
\item{celdaModel}{A \code{celdaModel} or \code{celdaList} object generated
using older versions of \code{celda}.}

\item{counts}{A numeric \link{matrix} of counts used to generate
\code{celdaModel}. Dimensions and MD5 checksum will be checked by
\link{compareCountMatrix}.}

\item{useAssay}{A string specifying the name of the
\link{assay} slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
A \linkS4class{SingleCellExperiment} object. Function
 parameter settings are stored in the \link{metadata}
 \code{"celda_parameters"} slot.
 Columns \code{celda_sample_label} and \code{celda_cell_cluster} in
 \link{colData} contain sample labels and celda cell
 population clusters. Column \code{celda_feature_module} in
 \link{rowData} contain feature modules.
}
\description{
Convert a old celda model object (\code{celda_C},
 \code{celda_G}, or \code{celda_CG} object) to a
 \linkS4class{SingleCellExperiment} object containing celda model
 information in \code{metadata} slot. Counts matrix is stored in the
 \code{"counts"} assay slot in \code{assays}.
}
\examples{
data(celdaCMod, celdaCSim)
sce <- celdatosce(celdaCMod, celdaCSim$counts)
data(celdaGMod, celdaGSim)
sce <- celdatosce(celdaGMod, celdaGSim$counts)
data(celdaCGMod, celdaCGSim)
sce <- celdatosce(celdaCGMod, celdaCGSim$counts)
data(celdaCGGridSearchRes, celdaCGSim)
sce <- celdatosce(celdaCGGridSearchRes, celdaCGSim$counts)
}
