<!-- badges: start -->
[![R-CMD-check](https://github.com/campbio/celda/workflows/R-CMD-check/badge.svg)](https://github.com/campbio/celda/actions)
[![Coverage Status](https://coveralls.io/repos/github/campbio/celda/badge.svg?branch=master)](https://coveralls.io/github/campbio/celda?branch=master)
<!-- badges: end -->

# celda: CEllular Latent Dirichlet Allocation

"celda" stands for "**CE**llular **L**atent **D**irichlet **A**llocation". It is a suite of Bayesian hierarchical models and supporting functions to perform gene and cell clustering for count data generated by single cell RNA-seq platforms. This algorithm is an extension of the Latent Dirichlet Allocation (LDA) topic modeling framework that has been popular in text mining applications. This package also includes a method called **DecontX** which can be used to estimate and remove contamination in single cell genomic data. 


## Installation Instructions

To install the latest stable release of **celda** from [Bioconductor](http://bioconductor.org/packages/celda/) (requires R version >= 3.6):

```
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("celda")
```

The latest stable version  of **celda** can be installed from GitHub using `devtools`:

```
library(devtools)
install_github("campbio/celda")
```

The development version of **celda** can also be installed from GitHub using `devtools`:
```
library(devtools)
install_github("campbio/celda@devel")
```

**NOTE** For MAC OSX users, `devtools::install_github()` requires installation of **libgit2.** This can be installed via homebrew:
```
brew install libgit2
```

Also, if you receive installation errors when Rcpp is being installed and compiled, try following the steps outlined here to solve the issue:

https://thecoatlessprofessor.com/programming/cpp/r-compiler-tools-for-rcpp-on-macos/

If you are running R 4.0.0 or later version on MacOS Catalina and you see error `'wchar.h' file not found`, you can try the method in this link:

https://discourse.mc-stan.org/t/dealing-with-catalina-iii/12731/5

If you are trying to install on MacOS in an Apple Silicon computater and you see the following error:

```
ld: warning: directory not found for option '-L/opt/gfortran/lib/gcc/x86_64-apple-darwin20.0/12.2.0'
ld: warning: directory not found for option '-L/opt/gfortran/lib'
ld: library not found for -lgfortran
clang: error: linker command failed with exit code 1 (use -v to see invocation)
make: *** [celda.so] Error 1
ERROR: compilation failed for package ‘celda’
```

You can solve this by downloading and installing the gfortran pkg located [here](https://mac.r-project.org/tools/gfortran-12.2-universal.pkg) and then running the following command:

```
sudo /opt/gfortran/bin/gfortran-update-sdk
```  


**NOTE** If you are trying to install **celda** using Rstudio and get this error: `could not find tools necessary to compile a package`, you can try this:
```
options(buildtools.check = function(action) TRUE)
```

## Vignettes and examples

To build the vignettes for Celda and DecontX during installation from GitHub, use the following command:

```
library(devtools)
install_github("campbio/celda", build_vignettes = TRUE)
```

Note that installation may take an extra 5-10 minutes for building of the vignettes. The Celda and DecontX vignettes can then be accessed via the following commands:
```
vignette("celda")
vignette("decontX")
```

## For developers
Check out our [Wiki](https://github.com/campbio/celda/wiki) for developer's guide if you want to contribute!
- [Celda Development Coding Style Guide](https://github.com/campbio/celda/wiki/Celda-Development-Coding-Style-Guide)
- [Celda Development Robust and Efficient Code](https://github.com/campbio/celda/wiki/Celda-Development-Robust-and-Efficient-Code)
- [Celda Development Rstudio configuration](https://github.com/campbio/celda/wiki/Celda-Development-Rstudio-configuration)
- [FAQ on how to use celda](https://github.com/campbio/celda/wiki/FAQ-on-how-to-use-celda)
- [FAQ on package development](https://github.com/campbio/celda/wiki/FAQ-on-package-development)
