% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{make_ranking_violin_plot}
\alias{make_ranking_violin_plot}
\title{make_ranking_violin_plot}
\usage{
make_ranking_violin_plot(de_table.marked = NA, de_table.test = NA,
  de_table.ref = NA, log10trans = FALSE, ...)
}
\arguments{
\item{de_table.marked}{The output of 
\code{\link{get_the_up_genes_for_all_possible_groups}} 
for the contrast of interest.}

\item{de_table.test}{A differential expression table of the 
query experiment,
as generated from \code{\link{contrast_each_group_to_the_rest}}}

\item{de_table.ref}{A differential expression table of the 
reference dataset,
as generated from \code{\link{contrast_each_group_to_the_rest}}}

\item{log10trans}{Plot on a log scale? Useful for distinishing multiple 
similar, yet distinct cell type that bunch at top of plot. Default=FALSE.}

\item{...}{Further options to be passed to 
\code{\link{get_the_up_genes_for_all_possible_groups}}, 
e.g. rankmetric}
}
\value{
A ggplot object.
}
\description{
Plot a panel of violin plots showing the distribution of the 'top' genes of 
each of query group, across the reference dataset.
}
\details{
In the plot output, each panel correponsds to a different group/cluster in 
the query experiment. The x-axis has the groups in the reference dataset. 
The y-axis is the rescaled rank of each 'top' gene from the query group, 
within each reference group.

Only the 'top' genes for each query group are plotted, forming the violin
plots - each individual gene is shown as a tickmark. Some groups have few 
top genes, and so their uncertanty can be seen on this plot.

The thick black lines reprenset the median gene rescaled ranking for each 
query group / reference group combination. Having this fall above the dotted 
median threshold marker is a quick indication of potential similarity. 
A complete lack of similarity would have a median rank around 0.5. Median 
rankings much less than 0.5 are common though (an 'anti-cell-groupA' 
signature), because genes overrepresented in one group in an experiment, 
are likely to be relatively 'underrepresented' in the other groups. 
Taken to an  
extreme, if there are only two reference groups, they'll be complete 
opposites.

Input can be either the precomputed \emph{de_table.marked} object for the 
comparison, OR both \emph{de_table.test} and \emph{de_table.ref} 
differential expression results to compare from 
\code{\link{contrast_each_group_to_the_rest}}
}
\examples{

# Make input
# de_table.demo_query <- contrast_each_group_to_the_rest(demo_query_se, "demo_query")
# de_table.demo_ref   <- contrast_each_group_to_the_rest(demo_ref_se,   "demo_ref")
   
# This:                                                  
make_ranking_violin_plot(de_table.test=de_table.demo_query, 
                         de_table.ref=de_table.demo_ref ) 
                        
# Is equivalent to this:
de_table.marked.query_vs_ref <- 
     get_the_up_genes_for_all_possible_groups( de_table.test=de_table.demo_query, 
                                               de_table.ref=de_table.demo_ref)
make_ranking_violin_plot(de_table.marked.query_vs_ref)


}
\seealso{
\code{\link{get_the_up_genes_for_all_possible_groups}} To make 
the input data.
}
