% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasting_functions.r
\name{contrast_each_group_to_the_rest_for_norm_ma_with_limma}
\alias{contrast_each_group_to_the_rest_for_norm_ma_with_limma}
\title{contrast_each_group_to_the_rest_for_norm_ma_with_limma}
\usage{

  contrast_each_group_to_the_rest_for_norm_ma_with_limma(norm_expression_table,
  sample_sheet_table, dataset_name, sample_name, group_name = "group",
  groups2test = NA, extra_factor_name = NA, pval_threshold = 0.01)
}
\arguments{
\item{norm_expression_table}{A logged, normalised expression table. Any 
filtering (removal of low-expression probes/genes)}

\item{sample_sheet_table}{Tab-separated text file of sample information.
Columns must have names. Sample/microarray ids should be listed under 
\bold{sample_name} column. The cell-type (or 'group') of each sample should 
be listed under a column \bold{group_name}.}

\item{dataset_name}{Short, meaningful name for this dataset/experiment.}

\item{sample_name}{Name of \bold{sample_sheet_table} with sample ID}

\item{group_name}{Name of \bold{sample_sheet_table} with group/cell-type. 
Default = "group"}

\item{groups2test}{An optional character vector specificing specific groups 
to check. By default (set to NA), all groups will be tested.}

\item{extra_factor_name}{Optionally, an extra cross-group factor (as column 
name in \bold{sample_sheet_table}) to include in the model used by limma. 
E.g. An individual/mouse id. Refer limma docs. Default = NA}

\item{pval_threshold}{For reporting only, a p-value threshold. 
Default = 0.01}
}
\value{
A tibble, the within-experiment de_table (differential expression
table)
}
\description{
This function loads and processes microarray data (from purified cell 
populations) that can be used as a reference.
}
\details{
Sometimes there are microarray studies measureing purified cell populations 
that would be measured together in a single-cell sequenicng experiment. 
E.g. comparing PBMC scRNA to FACs-sorted blood cell populations. 
This function 
will process microarray data with limma and format it for comparisions.

The microarray data used should consist of purified cell types 
from /emph{one single study/experiment} (due to batch effects). 
Ideally just those cell-types expected in the 
scRNAseq, but the method appears relatively robust to a few extra cell 
types.

Note that unlike the single-cell workflow there are no summarisedExperiment 
objects (they're not really comparable) - this function reads data and 
generates a table of within-dataset differentential expression contrasts in 
one step. Ie. equivalent to the output of 
\code{\link{contrast_each_group_to_the_rest}}.

Also, note that while downstream functions can accept 
the microarray-derived data as query datasets, 
its not really intended and assumptions might not
hold (Generally, its known what got loaded onto a microarray!)

The (otherwise optional) 'limma' package must be installed to use this 
function.
}
\examples{

contrast_each_group_to_the_rest_for_norm_ma_with_limma(
    norm_expression_table=demo_microarray_expr, 
    sample_sheet_table=demo_microarray_sample_sheet,
    dataset_name="DemoSimMicroarrayRef", 
    sample_name="cell_sample", group_name="group") 
    
\dontrun{ 
contrast_each_group_to_the_rest_for_norm_ma_with_limma(
   norm_expression_table, sample_sheet_table=samples_table, 
   dataset_name="Watkins2009PBMCs", extra_factor_name='description')
}


}
\seealso{
\code{\link{contrast_each_group_to_the_rest}} is the 
funciton that makes comparable output on the scRNAseq data (dataset_se 
objects).

\href{https://bioconductor.org/packages/release/bioc/html/limma.html}{Limma} 
Limma package for differential expression.

Other Data loading functions: \code{\link{load_dataset_10Xdata}},
  \code{\link{load_se_from_tables}}
}
\concept{Data loading functions}
