% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_how.R
\name{update_how}
\alias{update_how}
\title{Converts the count value of the given node.}
\usage{
update_how(input_graph, node_name, how, knockdown = TRUE)
}
\arguments{
\item{input_graph}{The graph object that processed in previous step/s.}

\item{node_name}{The name of the node whose count is to be changed.}

\item{how}{The change in terms of fold change.}

\item{knockdown}{specifies gene knockdown with default TRUE}
}
\value{
the graph object.
}
\description{
this function converts the count value of the given node.
}
\details{
update_how function calculates the current value of
given mirna or gene node on the graph object. User must specify
current value as fold change.
}
\examples{

data('minsamp')

priming_graph(minsamp, Competing_expression, miRNA_expression)\%>\%
   update_how('Gene1',3)

 priming_graph(minsamp, Competing_expression, miRNA_expression,
      aff_factor = c(seed_type,energy), deg_factor = region)\%>\%
   update_how('Gene1', 3)

   priming_graph(minsamp, Competing_expression, miRNA_expression,
       aff_factor = c(seed_type,energy), deg_factor = region)\%>\%
  update_how('Gene1', how=0, knockdown= TRUE)



}
