% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils2.R
\name{write_meta}
\alias{write_meta}
\title{Write meta genes to a file}
\usage{
write_meta(meta, file)
}
\arguments{
\item{meta}{List of meta genes output from \code{meta_genes}}

\item{file}{Output file name}
}
\value{
\code{NULL}
}
\description{
Write a csv file of meta gene lists from input list
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50, ncol=100, rank=5)
s <- scNMFSet(x$x)
s <- vb_factorize(s, ranks=seq(2,8), nrun=5)
plot(s)
m <- meta_genes(s, rank=5)
write_meta(m, file='meta.csv')
}
