% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{simulate_data}
\alias{simulate_data}
\title{Generate simulated data for factorization}
\usage{
simulate_data(nfeatures, nsamples, generate.factors = FALSE,
  nfactor = 10, alpha0 = 0.5, shuffle = TRUE)
}
\arguments{
\item{nfeatures}{Number of features \code{m} (e.g., genes).}

\item{nsamples}{Vector of sample sizes in each cluster. 
Rank \code{r} is equal to 
    the length of this vector. Sum of elements is the total 
    sample size \code{n}.}

\item{generate.factors}{Generate factor matrices \code{W} and \code{H},
each with dimension \code{n x r} and \code{r x n}. If \code{FALSE},
factor matrices are not used and count data are generated 
directly from
\code{r} multinomials for \code{m} genes.}

\item{nfactor}{Total RNA count of multinomials for each cluster with 
\code{generate.factors = FALSE}. Small \code{nfactor} will 
yield sparse count matrix.}

\item{alpha0}{Variance parameter of Dirichlet distribution from which 
multinomial probabilities are sampled with 
\code{generate.factors = FALSE}.}

\item{shuffle}{Randomly permute rows and columns of count matrix.}
}
\value{
If \code{generate.factors = TRUE}, list of components 
  \code{w} (basis matrix, \code{nfeatures x rank}),
        \code{h} (coefficient matrix, \code{rank x ncells}, where 
        \code{ncells}
        is equal to \code{n}, the sum of \code{nsamples}), and 
        \code{x}, a matrix of Poisson deviates with mean \code{W x H}.
        If \code{generate.factors = FALSE}, only the count matrix 
        \code{x} is in the list.
}
\description{
Use one of two schemes to generate simulated data suitable for 
testing factorization.
}
\details{
In one scheme (\code{generate.factors = TRUE}), simulated factor 
  matrices 
\code{W} and \code{H} are used to build count data \code{X = WH}.
In the second scheme, factor matrices are not used and \code{X} is 
  sampled directly from \code{r} (rank requested) sets of 
  multinomial distributions.
}
\examples{
set.seed(1)
x <- simulate_data(nfeatures=10,nsamples=c(20,20,60,40,30))
s <- scNMFSet(x)
s
}
