% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils2.R
\name{meta_gene.cv}
\alias{meta_gene.cv}
\title{Meta gene table with CV}
\usage{
meta_gene.cv(object = NULL, rank, basis.matrix = NULL, dbasis = NULL,
  max.per.cluster = 100, gene_names = NULL, subtract.mean = TRUE,
  log = TRUE, cv.max = Inf)
}
\arguments{
\item{object}{Main object containing factorization outcome}

\item{rank}{Rank for which meta gene is to be found}

\item{basis.matrix}{Basis matrix to work with. Only necessary when 
\code{object} is \code{NULL}.}

\item{dbasis}{Variance of basis matrix. Only necessary when 
\code{object} is \code{NULL}.}

\item{max.per.cluster}{Maximum meta genes per cluster.}

\item{gene_names}{Name of genes. If \code{NULL}, will be taken from row names.}

\item{subtract.mean}{Standardize magnitudes of basis elements by subtracting mean}

\item{log}{Use geometric mean.}

\item{cv.max}{Upper bound for CV in selecting meta genes.}
}
\value{
Data frame with meta genes and their CV in each column.
}
\description{
Generates meta gene table with coefficient of variation
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50, ncol=100, rank=5)
s <- scNMFSet(x$x)
s <- vb_factorize(s, ranks=seq(2,8), nrun=5)
plot(s)
meta_gene.cv(s, rank=5)
}
