% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scNMF_class.R
\docType{methods}
\name{colData<-,scNMFSet,ANY-method}
\alias{colData<-,scNMFSet,ANY-method}
\title{Cell annotation assignment}
\usage{
\S4method{colData}{scNMFSet,ANY}(x) <- value
}
\arguments{
\item{x}{Object containing cell annotation}

\item{value}{DataFrame to be substituted}
}
\value{
Updated column annotation
}
\description{
Cell annotation assignment
}
\examples{
library(S4Vectors)
x <- matrix(rpois(n=12,lambda=3),4,3)
rownames(x) <- seq_len(4)
colnames(x) <- c('a','b','c')
s <- scNMFSet(count=x,rowData=seq_len(4),colData=c('a','b','c'))
cols <- DataFrame(tissue=c('tissue1','tissue1','tissue2'))
rownames(cols) <- c('a','b','c')
colData(s) <- cols
s
}
