% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{computeDropouts}
\alias{computeDropouts}
\title{Impute Dropout Values in a Log-normalized Expression Count Matrix}
\usage{
computeDropouts(consMtx, logX, dropIds, fastSolver = TRUE, nCores)
}
\arguments{
\item{consMtx}{A numeric matrix representing the processed consensus matrix
obtained from clustering analysis.}

\item{logX}{A (sparse or dense) numeric matrix representing the transpose of
a log-normalized gene expression matrix. Rows correspond to cells, and 
columns correspond to genes.}

\item{dropIds}{A numeric vector containing the row/col indices of the 
dropouts to be imputed.}

\item{fastSolver}{A logical value indicating whether to use the fast solver
(default) or the slow solver.}

\item{nCores}{An integer specifying the number of cores to use for parallel
processing (if applicable).}
}
\value{
An imputed log-transformed count matrix (same dimensions as `logX`).
}
\description{
This function imputes dropout values (zeros) in a count matrix
  using either a fast numerical solver or a slower linear equations solver.
}
\examples{
library(scater)
library(BiocParallel)
library(splatter)

sce <- splatSimulate(group.prob = rep(1, 5)/5, sparsify = FALSE, 
        batchCells=100, nGenes=1000, method = "groups", verbose = FALSE, 
        dropout.type = "experiment")
sce <- logNormCounts(sce)
cores <- 2
logX <- as.matrix(logcounts(sce))
w <- rowVars_fast(logX, cores)
corMat <- getCorM("spearman", logcounts(sce), w, cores)
v <- doSVD(corMat, nCores=cores)
BPPARAM = MulticoreParam(cores)
consMtx <- runKM(logX, v, BPPARAM=bpparam())
dropIds <- findDropouts(logX, consMtx)
impLogX <- computeDropouts(consMtx, logX, dropIds, nCores=cores)

}
