% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbaf-obtainMultipleStudies.R
\name{obtainMultipleStudies}
\alias{obtainMultipleStudies}
\title{Obtain the requested data for various cancer studies.}
\usage{
obtainMultipleStudies(genesList, submissionName, studiesNames,
  desiredTechnique, cancerCode = FALSE, validateGenes = TRUE)
}
\arguments{
\item{genesList}{a list that contains at least one gene group}

\item{submissionName}{a character string containing name of interest. It is
used for naming the process.}

\item{studiesNames}{a character vector or a matrix that containes desired
cancer names. The character vector containes standard
names of cancer studies that can be found on cbioportal.org, such as
\code{"Acute Myeloid Leukemia (TCGA, NEJM 2013)"}. Alternatively, a matrix can
used if users prefer user-defined cancer names. In this case, the first
column of matrix comprises the standard cancer names while the second column
must contain the desired cancer names.}

\item{desiredTechnique}{a character string that is one of the following
techniques: \code{"RNA-Seq"}, \code{"RNA-SeqRTN"}, \code{"microRNA-Seq"},
\code{"microarray.mRNA"}, \code{"microarray.microRNA"} or
\code{"methylation"}.}

\item{cancerCode}{a logical value that tells the function to use cbioportal
abbreviated cancer names instead of complete cancer names, if set to be
\code{TRUE}. For example, \code{"laml_tcga_pub"} is the abbreviated name for
\code{"Acute Myeloid Leukemia (TCGA, NEJM 2013)"}.}

\item{validateGenes}{a logical value that, if set to be \code{TRUE}, function
will check each cancer study to find whether or not each gene has a record.
If a cancer study doesn't have a record for specific gene, it checks for
alternative gene names that cbioportal might use instead of the given gene
name.}
}
\value{
a BiocFileCach object that contains the obtained data without further
 processing. Name of the object is combination of \code{bfc_} and
 \code{submissionName}. Inside it, there is a section for the obtained data,
 which is stored as a list. At first level, this list is subdivided into
 diferent groups based on the list of genes that user has given the function,
  then each gene group itself contains one matrix for every cancer study.
  Additonally, if \code{validateGenes = TRUE}, another section that contains
  gene validation results will be created in the BiocFileCach object.
}
\description{
This function Obtains the requested data for the given genes
across multiple cancer studies. It can check whether or not all genes are
included in cancer studies and, if not, looks for the alternative gene names.
}
\details{
\tabular{lllll}{
Package: \tab cbaf \cr
Type: \tab Package \cr
Version: \tab 1.31.1 \cr
Date: \tab 2025-10-26 \cr
License: \tab Artistic-2.0 \cr
}
}
\examples{
genes <- list(K.demethylases = c("KDM1A", "KDM1B", "KDM2A", "KDM2B", "KDM3A",
 "KDM3B", "JMJD1C", "KDM4A"), K.methyltransferases = c("SUV39H1", "SUV39H2",
 "EHMT1", "EHMT2", "SETDB1", "SETDB2", "KMT2A", "KMT2A"))

studies <- c("Acute Myeloid Leukemia (TCGA, Provisional)",
"Adrenocortical Carcinoma (TCGA, Provisional)",
"Bladder Urothelial Carcinoma (TCGA, Provisional)",
"Brain Lower Grade Glioma (TCGA, Provisional)",
"Breast Invasive Carcinoma (TCGA, Provisional)")

obtainMultipleStudies(genes, "test2", studies, "RNA-Seq")

}
\author{
Arman Shahrisa, \email{shahrisa.arman@hotmail.com} [maintainer,
copyright holder]

Maryam Tahmasebi Birgani, \email{tahmasebi-ma@ajums.ac.ir}
}
