% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_config_diffs}
\alias{plot_config_diffs}
\title{Define a publication-style plot theme}
\usage{
plot_config_diffs(Config1, Config2, show_variant_names = FALSE)
}
\arguments{
\item{Config1}{variant by clone matrix defining the first clonal structure}

\item{Config2}{variant by clone matrix defining the second clonal structure}

\item{show_variant_names}{logical(1), should the variant names (rownames of
Config matrices) be shown on the plot? Default is \code{FALSE}.}
}
\value{
a ggplot heatmap style plot showing the differences between the two
Config matrices, specifically the differences Config1 - Config2.
}
\description{
Define a publication-style plot theme
}
\examples{
Config1 <- matrix(c(
    rep(0, 15), rep(1, 8), rep(0, 7),
    rep(1, 5), rep(0, 3), rep(1, 7)
), ncol = 3)
Config2 <- matrix(c(
    rep(0, 15), rep(1, 8), rep(1, 7),
    rep(0, 5), rep(1, 3), rep(1, 7)
), ncol = 3)
rownames(Config1) <- rownames(Config2) <- paste0("var", 1:nrow(Config1))
colnames(Config1) <- colnames(Config2) <- paste0("clone", 1:ncol(Config1))
plot_config_diffs(Config1, Config2)
}
