% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clone_id.R
\name{assign_cells_to_clones}
\alias{assign_cells_to_clones}
\title{Assign cells to clones from cardelino results}
\usage{
assign_cells_to_clones(prob_mat, threshold = 0.5)
}
\arguments{
\item{prob_mat}{numeric matrix (cells x clones) of clone posterior
probabilities as output by \code{\link{clone_id}}}

\item{threshold}{numeric(1), posterior probability threshold for cell-clone
assignment: if posterior probability is above threshold, assign cell to
clone, otherwise leave cell "unassigned"}
}
\value{
a \code{data.frame} with cell ID, assigned clone label and maximum
posterior probability across clones.
}
\description{
Assign cells to clones from cardelino results
}
\examples{
data(example_donor)
assignments <- clone_id(A_clone, D_clone, Config = tree$Z, inference = "EM")
df <- assign_cells_to_clones(assignments$prob)
head(df)
table(df$clone)
}
\author{
Davis McCarthy
}
