% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getListProfData.R
\name{getProfData}
\alias{getProfData}
\title{Search and get genetic profiles (CNA,mRNA, Methylation, Mutation...)}
\usage{
getProfData(study,genProf, listGenProf, GeneList, Mut)
}
\arguments{
\item{study}{Study ID}

\item{genProf}{Genetic Profile id (cancer_study_id_[mutations, cna, methylation, mrna ]).}

\item{listGenProf}{A list of Genetic Profiles for one study.}

\item{GeneList}{A list of genes}

\item{Mut}{Condition to set if the genetic profile is mutation or not (0,1)}
}
\value{
A data frame with Genetic profile
}
\description{
Search and get genetic profiles (CNA,mRNA, Methylation, Mutation...)
}
\details{
See \url{https://github.com/kmezhoud/bioCancer/wiki}
}
\examples{
cgds <- cBioPortal(
hostname = "www.cbioportal.org",
protocol = "https",
api = "/api/v2/api-docs"
)
\dontrun{
getDataByGenes( api =  cgds,
studyId = "gbm_tcga_pub",
genes = c("NF1", "TP53", "ABL1"),
by = "hugoGeneSymbol",
molecularProfileIds = "gbm_tcga_pub_mrna"
)
}
}
