% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENCODE.R
\name{prepareENCODEgeneExpression}
\alias{prepareENCODEgeneExpression}
\title{Load ENCODE gene expression data}
\usage{
prepareENCODEgeneExpression(samples)
}
\arguments{
\item{samples}{List of loaded ENCODE samples}
}
\value{
Data frame containing gene read counts
}
\description{
Load ENCODE gene expression data
}
\examples{
if (interactive()) {
  # Load ENCODE metadata for a specific cell line and gene
  cellLine <- "HepG2"
  gene <- "EIF4G1"
  ENCODEmetadata <- downloadENCODEknockdownMetadata(cellLine, gene)

  # Load samples based on filtered ENCODE metadata
  ENCODEsamples <- loadENCODEsamples(ENCODEmetadata)[[1]]

  prepareENCODEgeneExpression(ENCODEsamples)
}
}
\seealso{
\code{\link{convertGeneIdentifiers}()}

Other functions related with using ENCODE expression data: 
\code{\link{downloadENCODEknockdownMetadata}()},
\code{\link{loadENCODEsamples}()},
\code{\link{performDifferentialExpression}()}
}
\concept{functions related with using ENCODE expression data}
