% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMap.R
\name{plot.perturbationChanges}
\alias{plot.perturbationChanges}
\alias{[.perturbationChanges}
\alias{dim.perturbationChanges}
\alias{dimnames.perturbationChanges}
\title{Operations on a \code{perturbationChanges} object}
\usage{
\method{plot}{perturbationChanges}(
  x,
  perturbation,
  input,
  method = c("spearman", "pearson", "gsea"),
  geneSize = 150,
  genes = c("both", "top", "bottom"),
  ...,
  title = NULL
)

\method{[}{perturbationChanges}(x, i, j, drop = FALSE, ...)

\method{dim}{perturbationChanges}(x)

\method{dimnames}{perturbationChanges}(x)
}
\arguments{
\item{x}{\code{perturbationChanges} object}

\item{perturbation}{Character (perturbation identifier) or a
\code{similarPerturbations} table (from which the respective perturbation
identifiers are retrieved)}

\item{input}{\code{Named numeric vector} of differentially expressed genes
whose names are gene identifiers and respective values are a statistic that
represents significance and magnitude of differentially expressed genes
(e.g. t-statistics); or \code{character} of gene symbols composing a gene
set that is tested for enrichment in reference data (only used if
\code{method} includes \code{gsea})}

\item{method}{Character: comparison method (\code{spearman}, \code{pearson}
or \code{gsea}; multiple methods may be selected at once)}

\item{geneSize}{Numeric: number of top up-/down-regulated genes to use as
gene sets to test for enrichment in reference data; if a 2-length numeric
vector, the first index is the number of top up-regulated genes and the
second index is the number of down-regulated genes used to create gene
sets; only used if \code{method} includes \code{gsea} and if \code{input}
is not a gene set}

\item{genes}{Character: when plotting gene set enrichment analysis (GSEA),
plot most up-regulated genes (\code{genes = "top"}), most down-regulated
genes (\code{genes = "bottom"}) or both (\code{genes = "both"}); only used
if \code{method = "gsea"} and \code{geneset = NULL}}

\item{...}{Extra arguments}

\item{title}{Character: plot title (if \code{NULL}, the default title depends
on the context; ignored when plotting multiple perturbations)}

\item{i, j}{Character or numeric indexes specifying elements to extract}

\item{drop}{Boolean: coerce result to the lowest possible dimension?}
}
\value{
Subset, plot or return dimensions or names of a
  \code{perturbationChanges} object
}
\description{
Operations on a \code{perturbationChanges} object
}
\examples{
data("diffExprStat")
data("cmapPerturbationsKD")

compareKD <- rankSimilarPerturbations(diffExprStat, cmapPerturbationsKD)
EIF4G1knockdown <- grep("EIF4G1", compareKD[[1]], value=TRUE)
plot(cmapPerturbationsKD, EIF4G1knockdown, diffExprStat, method="spearman")
plot(cmapPerturbationsKD, EIF4G1knockdown, diffExprStat, method="pearson")
plot(cmapPerturbationsKD, EIF4G1knockdown, diffExprStat, method="gsea")

data("cmapPerturbationsCompounds")
pert <- "CVD001_HEPG2_24H:BRD-A14014306-001-01-1:4.1"
plot(cmapPerturbationsCompounds, pert, diffExprStat, method="spearman")
plot(cmapPerturbationsCompounds, pert, diffExprStat, method="pearson")
plot(cmapPerturbationsCompounds, pert, diffExprStat, method="gsea")

# Multiple cell line perturbations
pert <- "CVD001_24H:BRD-A14014306-001-01-1:4.1"
plot(cmapPerturbationsCompounds, pert, diffExprStat, method="spearman")
plot(cmapPerturbationsCompounds, pert, diffExprStat, method="pearson")
plot(cmapPerturbationsCompounds, pert, diffExprStat, method="gsea")
}
\seealso{
Other functions related with the ranking of CMap perturbations: 
\code{\link{as.table.referenceComparison}()},
\code{\link{filterCMapMetadata}()},
\code{\link{getCMapConditions}()},
\code{\link{getCMapPerturbationTypes}()},
\code{\link{loadCMapData}()},
\code{\link{loadCMapZscores}()},
\code{\link{parseCMapID}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()},
\code{\link{prepareCMapPerturbations}()},
\code{\link{print.similarPerturbations}()},
\code{\link{rankSimilarPerturbations}()}
}
\concept{functions related with the ranking of CMap perturbations}
