% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENCODE.R
\name{performDifferentialExpression}
\alias{performDifferentialExpression}
\title{Perform differential gene expression based on ENCODE data}
\usage{
performDifferentialExpression(counts)
}
\arguments{
\item{counts}{Data frame: gene expression}
}
\value{
Data frame with differential gene expression results between
knockdown and control
}
\description{
Perform differential gene expression based on ENCODE data
}
\examples{
if (interactive()) {
  # Download ENCODE metadata for a specific cell line and gene
  cellLine <- "HepG2"
  gene <- "EIF4G1"
  ENCODEmetadata <- downloadENCODEknockdownMetadata(cellLine, gene)

  # Download samples based on filtered ENCODE metadata
  ENCODEsamples <- loadENCODEsamples(ENCODEmetadata)[[1]]

  counts <- prepareENCODEgeneExpression(ENCODEsamples)

  # Remove low coverage (at least 10 counts shared across two samples)
  minReads   <- 10
  minSamples <- 2
  filter <- rowSums(counts[ , -c(1, 2)] >= minReads) >= minSamples
  counts <- counts[filter, ]

  # Convert ENSEMBL identifier to gene symbol
  counts$gene_id <- convertGeneIdentifiers(counts$gene_id)

  # Perform differential gene expression analysis
  diffExpr <- performDifferentialExpression(counts)
}
}
\seealso{
Other functions related with using ENCODE expression data: 
\code{\link{downloadENCODEknockdownMetadata}()},
\code{\link{loadENCODEsamples}()},
\code{\link{prepareENCODEgeneExpression}()}
}
\concept{functions related with using ENCODE expression data}
