% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugSetEnrichment.R
\name{loadDrugDescriptors}
\alias{loadDrugDescriptors}
\title{Load table with drug descriptors}
\usage{
loadDrugDescriptors(
  source = c("NCI60", "CMap"),
  type = c("2D", "3D"),
  file = NULL,
  path = NULL
)
}
\arguments{
\item{source}{Character: source of compounds used to calculate molecular
descriptors (\code{NCI60} or \code{CMap})}

\item{type}{Character: load \code{2D} or \code{3D} molecular descriptors}

\item{file}{Character: filepath to drug descriptors (automatically downloaded
if file does not exist)}

\item{path}{Character: folder where to find files (optional; \code{file} may
contain the full filepath if preferred)}
}
\value{
Data table with drug descriptors
}
\description{
Load table with drug descriptors
}
\examples{
loadDrugDescriptors()
}
\seealso{
Other functions for drug set enrichment analysis: 
\code{\link{analyseDrugSetEnrichment}()},
\code{\link{plotDrugSetEnrichment}()},
\code{\link{prepareDrugSets}()}
}
\concept{functions for drug set enrichment analysis}
