% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMap.R
\name{filterCMapMetadata}
\alias{filterCMapMetadata}
\title{Filter CMap metadata}
\usage{
filterCMapMetadata(
  metadata,
  cellLine = NULL,
  timepoint = NULL,
  dosage = NULL,
  perturbationType = NULL
)
}
\arguments{
\item{metadata}{Data frame (CMap metadata) or character (respective filepath)}

\item{cellLine}{Character: cell line (if \code{NULL}, all values are loaded)}

\item{timepoint}{Character: timepoint (if \code{NULL}, all values are loaded)}

\item{dosage}{Character: dosage (if \code{NULL}, all values are loaded)}

\item{perturbationType}{Character: type of perturbation (if \code{NULL}, all
perturbation types are loaded)}
}
\value{
Filtered CMap metadata
}
\description{
Filter CMap metadata
}
\examples{
cmapMetadata <- loadCMapData("cmapMetadata.txt", "metadata")
filterCMapMetadata(cmapMetadata, cellLine="HEPG2", timepoint="2 h",
                   dosage="25 ng/mL")
}
\seealso{
Other functions related with the ranking of CMap perturbations: 
\code{\link{as.table.referenceComparison}()},
\code{\link{getCMapConditions}()},
\code{\link{getCMapPerturbationTypes}()},
\code{\link{loadCMapData}()},
\code{\link{loadCMapZscores}()},
\code{\link{parseCMapID}()},
\code{\link{plot.perturbationChanges}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()},
\code{\link{prepareCMapPerturbations}()},
\code{\link{print.similarPerturbations}()},
\code{\link{rankSimilarPerturbations}()}
}
\concept{functions related with the ranking of CMap perturbations}
