% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{volcanoPlot}
\alias{volcanoPlot}
\title{Volcano plot with formatted x and y axis label.}
\usage{
volcanoPlot(
  df,
  pValName,
  lFCName,
  sigThreshold = 0.05,
  logFCThreshold = 1,
  labelName = NULL,
  selectedLabel = NULL,
  palette = "nejm"
)
}
\arguments{
\item{df}{a data.frame object}

\item{pValName}{column name of df which provides p-values}

\item{lFCName}{column name of df which provides log fold change values}

\item{sigThreshold}{Threshold for p-values}

\item{logFCThreshold}{Threshold for log fold change values}

\item{labelName}{column name of df to label the dots}

\item{selectedLabel}{which dots to highlight}

\item{palette}{one of "npg" ,"aaas", "lancet", "jco", "ucscgb", "uchicago",
"simpsons" and "nejm" or similar to viridis::cividis(3)}
}
\value{
ggplot object
}
\description{
Volcano plot with formatted x and y axis label.
}
