% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{use_multDE}
\alias{use_multDE}
\title{To identify differentially expressed genes by multiple methods}
\usage{
use_multDE(
  deFun_list,
  return.df = FALSE,
  se,
  colData_id,
  control,
  treatment,
  ...
)
}
\arguments{
\item{deFun_list}{a list of function which can perform differential expression analysis}

\item{return.df}{whether to return all results aggregated form of data.frame or
a list of results. Default is FALSE}

\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{colData_id}{One of the columns of colData(se). It should be factors of more than one value.}

\item{control}{Base level and one of the factor values of \code{colData(se)[[colData_id]]}}

\item{treatment}{one of the factor values of \code{colData(se)[[colData_id]]}}

\item{...}{other arguments to be passed to functions listed in deFun_list}
}
\value{
a list or data.frame
}
\description{
To identify differentially expressed genes by multiple methods
}
\examples{

se <- readRDS(system.file("extdata",
        "rat_vole_mouseSE_salmon.rds",
        package = "broadSeq"))

# To reduce runtime
se <- se[rowData(se)$chromosome_name == 2,colData(se)$species == "Mouse"]

# First define a named list of functions
funs <- list(limma_trend = use_limma_trend, limma_voom = use_limma_voom,
             edgeR_exact = use_edgeR_exact, edgeR_glm = use_edgeR_GLM,
             deseq2 = use_deseq2,
             DELocal = use_DELocal, noiseq = use_NOIseq,
             EBSeq = use_EBSeq)


multi_result <- broadSeq::use_multDE(
    se <- se[rowData(se)$chromosome_name == 2,colData(se)$species == "Mouse"],
    deFun_list = funs, return.df = TRUE,
    colData_id = "stage", control = "Bud", treatment = "Cap",
    rank = TRUE)
}
