% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{use_deseq2}
\alias{use_deseq2}
\title{To use SummarizedExperiment with package DESeq2}
\usage{
use_deseq2(se, colData_id, control, treatment, rank = FALSE, ...)
}
\arguments{
\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{colData_id}{One of the columns of colData(se). It should be factors of more than one value.}

\item{control}{Base level and one of the factor values of \code{colData(se)[[colData_id]]}}

\item{treatment}{one of the factor values of \code{colData(se)[[colData_id]]}}

\item{rank}{Logical value default FALSE. If true the result will have an
additional column named "rank" and the results are ranked on "padj"}

\item{...}{other arguments to be passed to main function DESeq2::\code{\link{results}}.}
}
\value{
a data.frame converted from DESeq2::\code{\link{DESeqResults}}
}
\description{
A wrapper function of DESeq2 where input is an object of \code{\link{SummarizedExperiment}}
}
\examples{

se <- readRDS(system.file("extdata",
        "rat_vole_mouseSE_salmon.rds",
        package = "broadSeq"))

# To reduce runtime
se <- se[rowData(se)$chromosome_name == 2,colData(se)$species == "Mouse"]

result <-
    use_deseq2(se = se,
           colData_id = "stage", control = "Bud", treatment = "Cap",
           rank = TRUE)
}
